//
//  CMS_Flow.swift
//  Composr Mobile SDK
//
//  Created by Aaswini on 06/08/14.
//  Copyright (c) 2014 Aaswini. All rights reserved.
//
/*
 
 CMS_Flow
 
 void access_denied() - opens the login view controller, and then have that controller close and the opener view controller refresh
 void attach_message(string msg) - creates a popup alert, alert title is 'Message'
 void inform_screen(string msg) - creates a popup alert then closes the view controller, alert title is 'Message'
 void warn_screen(string msg) - creates a popup alert then closes the view controller, alert title is 'Warning'
 void redirect_screen(className viewController) - transfers to a different view controller
 
 */

import UIKit
import Foundation

class CMS_Flow: NSObject {
    class func access_denied() {
        var loginCntroller = CMSLoginViewController()
        var navController = UINavigationController(rootViewController: loginCntroller)
        var appDelegate = UIApplication.sharedApplication().delegate!
        appDelegate.window!.rootViewController!.presentViewController(navController, animated: true, completion: { _ in })
    }
    
    /**
     *  Present an Alert with Title "Message"
     *
     *  @param msg Message to be displayed
     */
    class func attach_message(msg: String) {
        var alert = UIAlertView(title: "Message", message: msg, delegate: nil, cancelButtonTitle: "OK")
        alert.show()
    }
    
    /**
     *  Present an Alert with Title "Message" and dismiss the calling view controller
     *
     *  @param msg            Message to be displayed
     *  @param viewController Calling view controller
     */
    class func inform_screen(msg: String, viewController: UIViewController) {
        var alert = UIAlertView(title: "Message", message: msg, delegate: nil, cancelButtonTitle: "OK")
        alert.show()
        viewController.dismissViewControllerAnimated(true, completion: { _ in })
    }
    
    /**
     *  Present an Alert with Title "Warning" and dismiss the calling view controller
     *
     *  @param msg            Message to be displayed
     *  @param viewController Calling view controller
     */
    class func warn_screen(msg: String, viewController: UIViewController) {
        var alert = UIAlertView(title: "Warning", message: msg, delegate: nil, cancelButtonTitle: "OK")
        alert.show()
        viewController.dismissViewControllerAnimated(true, completion: { _ in })
    }
    
    /**
     *  Transfers to a different view controller
     *
     *  @param sourceViewController Source view Controller
     *  @param viewController       Destination view Controller
     */
    class func redirect_screen(sourceViewController: UIViewController, viewController: UIViewController) {
        sourceViewController.presentViewController(viewController, animated: true, completion: { _ in })
    }
}